*Size Distribution 2000

*---------------------------------------------------
* Sort correspondence file between naics and sic
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\naics2sic.dta", clear
sort naics
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\naics2sic.dta", replace
*---------------------------------------------------
* Building adjustment coefficients file by taking the average of adjustment coefficients in SIC

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\adjustment.dta", clear
replace sic = 1014 if (sic==1000)|(sic==1200)|(sic==1400)
replace sic = 2021 if (sic==2000)|(sic==2100)
replace sic = 2223 if (sic==2200)|(sic==2300)
replace sic = 3839 if (sic==3800)|(sic==3900)
replace sic = 6061 if (sic==6000)|(sic==6100)
replace sic = 6364 if (sic==6300)|(sic==6400)
replace sic = 7381 if (sic==7300)|(sic==7500)|(sic==8100)
collapse (mean) adjustment , by(sic)
rename sic sic2

save "C:\Documents and Settings\Proprio\My Documents\RA\USA\adjustmentnaics.dta", replace

*---------------------------------------------------
* Construct est2000

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\est2000.dta", clear
rename establishments est2000
rename establishment_size minsize

*Harmonizing classification

drop if naics=="--"
drop if naics=="31-33"
replace naics = "4445" if naics=="44-45"
drop if naics=="48-49"
destring naics, replace
drop if (naics>230)&(naics<240)
drop if (naics>420)&(naics<460)
replace naics = 230 if naics==23
replace naics = 420 if naics==42
drop if naics < 100
replace naics = 23 if naics==230
replace naics = 42 if naics==420

sort naics
merge naics using "C:\Documents and Settings\Proprio\My Documents\RA\USA\naics2sic.dta"
drop _merge
drop if sic2==.

collapse (sum) est2000 , by(sic2 minsize)

*transfer size

replace minsize = "0" if minsize=="0 employees"
drop if minsize=="Total"
replace minsize = "10000" if minsize =="10,000 or more employees" 
gen size = word(subinstr(minsize,"-"," -",. ),1)
replace size = subinstr(size,",","",. )
replace size="10000" if minsize=="10000"
destring size, replace
drop minsize
gen minsize = size
drop size

save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest2000.dta", replace
fillin sic2 minsize
drop if minsize == 0
replace est2000 = 0 if est2000==.
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest2000.dta", replace

*-----------------------------
* Compute the total number of establishments per industry in 2000

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest2000.dta", clear
collapse (sum) est2000, by(sic2)
rename est2000 tot
sort sic2
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intesttotal2000.dta", replace
*----------------------------------------------------------------
* Merge the total number of firms to intest2000.dta

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest2000.dta", clear
sort sic2
merge sic2 using "C:\Documents and Settings\Proprio\My Documents\RA\USA\intesttotal2000.dta"
drop _merge
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intP00.dta", replace

*----------------------------------------------------------------
* Compute the Pj's

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intP00.dta", clear
sort sic2 minsize
gen Pj = tot
replace Pj = Pj[_n-1] - est2000[_n-1] if (sic2[_n]==sic2[_n-1])
replace Pj = Pj/tot
sort sic2
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

*---------------------------------------------------------------------
*Create ks00.dta

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\cenaics.dta", clear

rename _1987 ce1987
rename _1988 ce1988
rename _1989 ce1989
rename _1990 ce1990
rename _1991 ce1991
rename _1992 ce1992
rename _1993 ce1993
rename _1994 ce1994
rename _1995 ce1995
rename _1996 ce1996
rename _1997 ce1997
rename _1998 ce1998
rename _1999 ce1999
rename _2000 ce2000
rename _2001 ce2001

sort sic2
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ksnaics.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\gdpnaics.dta", clear
sort sic2
merge sic2 using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ksnaics.dta"

rename _1987 gdp1987
rename _1988 gdp1988
rename _1989 gdp1989
rename _1990 gdp1990
rename _1991 gdp1991
rename _1992 gdp1992
rename _1993 gdp1993
rename _1994 gdp1994
rename _1995 gdp1995
rename _1996 gdp1996
rename _1997 gdp1997
rename _1998 gdp1998
rename _1999 gdp1999
rename _2000 gdp2000
rename _2001 gdp2001
drop _merge
sort sic2
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ksnaics.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\adjustmentnaics.dta", clear
sort sic2
merge sic2 using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ksnaics.dta"
drop _merge

*Definition of KS
gen ks00 = 1-ce2000/gdp2000
gen ks00adj = ks00*adjustment
sort sic2
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks00.dta", replace
*------------------------------------------------------------------------------------------------
*Merge ks00 and file with Pj's

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", clear
sort sic2
merge sic2 using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks00.dta"
drop _merge

*------------------------------------------------------------------
*Regressions

gen lnPj = ln(Pj)
gen lsize = ln(minsize)
gen l2size = (ln(minsize))^2

gen ks00l2size = ks00*l2size
gen ks00adjl2size = ks00adj*l2size

xi: reg lnPj i.sic2*lsize l2size ks00l2size if (ks00 <= 0.5)&(ks00 >=0)
xi: reg lnPj i.sic2*lsize l2size ks00adjl2size if (ks00adj <= 0.5)&(ks00adj >=0)

save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

*-------------------------------------------------------------------
*Figure 8 - 2000 

gen avsize = 0
collapse avsize , by(minsize)
replace avsize = (minsize+minsize[_n+1] - 1)/2
replace avsize = 12500 if minsize==10000
sort minsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\figure82000.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", clear
sort minsize
merge minsize using "C:\Documents and Settings\Proprio\My Documents\RA\USA\figure82000.dta"
drop _merge

keep if ks00adj<0.5
keep if ks00adj>0
collapse (sd) avsize [aw=est2000],by(ks00adj)

save "C:\Documents and Settings\Proprio\My Documents\RA\USA\figure82000.dta", replace

